import os
import shutil
from pathlib import Path

def process_files(directory):
    # 确保目录存在
    if not os.path.exists(directory):
        print(f"目录 {directory} 不存在!")
        return

    # 遍历所有子目录
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith('.txt'):
                file_path = os.path.join(root, file)
                temp_file = file_path + '.temp'
                
                try:
                    # 读取并处理文件
                    with open(file_path, 'r', encoding='utf-8') as f:
                        lines = f.readlines()
                    
                    # 过滤掉包含 "།" 的行和空行
                    filtered_lines = [line for line in lines 
                                   if "།" not in line and line.strip()]
                    
                    # 写入临时文件
                    with open(temp_file, 'w', encoding='utf-8') as f:
                        f.writelines(filtered_lines)
                    
                    # 替换原文件
                    shutil.move(temp_file, file_path)
                    print(f"处理完成: {file_path}")
                    
                except Exception as e:
                    print(f"处理文件 {file_path} 时出错: {str(e)}")
                    if os.path.exists(temp_file):
                        os.remove(temp_file)

def main():
    while True:
        directory = input("请输入要处理的文件夹路径（输入 'q' 退出）: ")
        if directory.lower() == 'q':
            break
            
        if os.path.exists(directory):
            confirm = input(f"确认要处理目录 {directory} 中的所有txt文件吗？(y/n): ")
            if confirm.lower() == 'y':
                process_files(directory)
                print("处理完成！")
            else:
                print("已取消操作。")
        else:
            print("目录不存在，请重新输入！")

if __name__ == "__main__":
    main()
